<?php
include('include/session.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the product parameter is set
if (isset($_GET['product'])) {
    $selected_product = $_GET['product'];

    // Use prepared statements to prevent SQL injection
    $sql = "SELECT DISTINCT variation FROM (
                SELECT variation FROM product_variation WHERE product = ? 
                UNION 
                SELECT variation FROM arrival_store WHERE product = ?
            ) AS combined_variations";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("ss", $selected_product, $selected_product);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if there are rows in the result
    if ($result->num_rows > 0) {
        echo '<option value="">' ."Select Variations". '</option>';
        while ($row = $result->fetch_assoc()) {
            echo '<option value="' . $row["variation"] . '">' . $row["variation"] . '</option>';
        }
    } else {
        // No variations found for the selected product
        echo '<option value="">No Variations Found</option>';
    }

    // Close the prepared statement
    $stmt->close();
} else {
    // If product parameter is not set
    echo '<option value="">Select Product First</option>';
}

// Close the database connection
$connection->close();
?>
