<?php
include('include/session.php');
// session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the variation ID is received through POST
if(isset($_POST['variation'])) {
    $variationId = $_POST['variation'];

    // Prepare and execute SQL query to fetch variation details
    $sql = "SELECT product_id, price, quantity FROM product_variation WHERE variation = ?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("s", $variationId); // Assuming variation is a string, change "s" if it's an integer
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query executed successfully
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $response = array(
            'success' => true,
             'product_id' => $row['product_id'],
            'price' => $row['price'],
            'quantity' => $row['quantity']
        );
        echo json_encode($response);
    } else {
        // If variation not found, return an error response
        $response = array(
            'success' => false,
            'error' => 'Variation not found'
        );
        echo json_encode($response);
    }

    // Close database connection and statement
    $stmt->close();
    $connection->close();
} else {
    // If variation ID is not received, return an error response
    $response = array(
        'success' => false,
        'error' => 'Variation ID not provided'
    );
    echo json_encode($response);
}
?>