<?php
include('include/session.php');
// session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;

// Check if the product name is received through GET
if(isset($_GET['product'])) {
    $product = $_GET['product'];

    // Prepare and execute SQL query to fetch category
    $sql = "SELECT category FROM product WHERE product = ?";
    $stmt = $connection->prepare($sql);
    $stmt->bind_param("s", $product); // Assuming product is a string, change "s" if it's an integer
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if the query executed successfully         
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $response = array(
            'success' => true,
            'category' => $row['category']   
        );
        echo json_encode($response);
    } else {
        $response = array(
            'success' => false,
            'error' => 'Product not found'
        );
        echo json_encode($response);
    }

    // Close database connection and statement
    $stmt->close();
    $connection->close();
} else {
    // If product name is not received, return an error response
    $response = array(
        'success' => false,
        'error' => 'Product not provided'
    );
    echo json_encode($response);
}
?>
