<?php
include('include/session.php');
// session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include_once('connection.php');
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
// Check if the order_id is provided in the URL
if (isset($_GET['order_id'])) {
    $id = $_GET['order_id'];

    // Validate $id to ensure it's a valid double value
    if (!is_numeric($id)) {
        echo "Invalid order ID.";
        exit();
    }

    // Prepare the delete statement
    $query = "DELETE FROM order_summery WHERE order_id = ?";
    $stmt = $connection->prepare($query);

    // Bind the parameter as a string since the order_id is of type DOUBLE
    $stmt->bind_param("s", $id);

    // Execute the delete statement
    if ($stmt->execute()) {
        // Check if any rows were affected
        if ($stmt->affected_rows > 0) {
            echo '<script>alert("Record with ID ' . $id . ' deleted successfully.");</script>';
        } else {
            echo '<script>alert("No record found with ID ' . $id . '");</script>';
        }
    } else {
        echo '<script>alert("Error deleting record: ' . $stmt->error . '");</script>';
    }

    // Close the statement
    $stmt->close();

    // Redirect to the order list page
    echo '<script>window.location.href = "_new_order_list.php";</script>';
    exit();
} else {
    echo "Invalid request. No ID specified for deletion.";
}
?>
