<?php
include('include/session.php');
include('connection.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['password'];
    $verify_password = $_POST['verify_password'];

    // Validate input
    if (empty($current_password) || empty($new_password) || empty($verify_password)) {
        header('Location: reset_password.php?error=All fields are required');
        exit();
    }

    if ($new_password !== $verify_password) {
        header('Location: reset_password.php?error=New passwords do not match');
        exit();
    }

    if (strlen($new_password) < 8 || strlen($new_password) > 20 || strpos($new_password, ' ') !== false) {
        header('Location: reset_password.php?error=Password must be 8-20 characters long and must not contain spaces');
        exit();
    }

    $dbConnection = new DbConnection();
    $connection = $dbConnection->connection;

    // Fetch the user's current hashed password from the database
    $user_id = $_SESSION['id'];
    $stmt = $connection->prepare("SELECT password FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($hashed_password);
    $stmt->fetch();
    $stmt->close();

    // Check if a password was retrieved
    if ($hashed_password === null) {
        header('Location: reset_password.php?error=No password found for user');
        exit();
    }

    // Verify the current password using bcrypt
    if (!password_verify($current_password, $hashed_password)) {
        header('Location: reset_password.php?error=Current password is incorrect');
        exit();
    }

    // Hash the new password using bcrypt
    $new_hashed_password = password_hash($new_password, PASSWORD_BCRYPT);

    // Update the new password in the database
    $stmt = $connection->prepare("UPDATE users SET password = ? WHERE id = ?");
    $stmt->bind_param("si", $new_hashed_password, $user_id);
    if ($stmt->execute()) {
        header('Location: reset_password.php?success=Password updated successfully');
    } else {
        header('Location: reset_password.php?error=Failed to update password');
    }
    $stmt->close();
}
?>
<html lang="en">
<head>
    <link rel="stylesheet" href="assets/css/style.css">
    <?php include('include/header_links.php'); ?>
</head>
<body>
    <form action="reset_password.php" method="POST">
        <?php if (isset($_GET['error'])) { ?>
            <p class="error"><?php echo htmlspecialchars($_GET['error']); ?></p>
        <?php } ?>

        <?php if (isset($_GET['success'])) { ?>
            <p class="success"><?php echo htmlspecialchars($_GET['success']); ?></p>
        <?php } ?>

        <div class="container_main">
            <div class="card card-outline-secondary">
                <div class="card-header">
                    <h3 class="mb-0">Reset Your Password</h3>
                </div>
                <div class="card-body">
                    <div class="form">
                        <div class="form-group">
                            <label for="inputPasswordOld">Current Password</label>
                            <input type="password" class="form-control" id="inputPasswordOld" name="current_password" required="">
                        </div>
                        <div class="form-group">
                            <label for="inputPasswordNew">New Password</label>
                            <input type="password" class="form-control" id="inputPasswordNew" name="password" required="">
                            <span class="form-text small text-muted">
                                The password must be 8-20 characters and must <em>not</em> contain spaces.
                            </span>
                        </div>
                        <div class="form-group">
                            <label for="inputPasswordNewVerify">Verify</label>
                            <input type="password" class="form-control" id="inputPasswordNewVerify" name="verify_password" required="">
                            <span class="form-text small text-muted">
                                To confirm, type the new password again.
                            </span>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-success btn-lg float-right">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
