<?php
include('include/session.php');
// session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('include/navigation.php');
include('connection.php');
include('class.php');

// Establish database connection
$dbConnection = new DbConnection();
$connection = $dbConnection->connection;
?>
<html lang="en">
<head>
    <link rel="stylesheet" href="assets/css/style.css">
    <?php include('include/header_links.php'); ?>
</head>
<style>
.nativeDatePicker{
   
    display:flex;
    justify-content:center;
    align-items:center;
}

.month-visit{
    width:500px;
    height:500px;
    border-radius:5px;
}

input[type="text"]{
    width:250px;
    border:2px solid black;
    border-radius:5px;
    height:50px;
}
</style>
<body>
    <div class="container_main">
          <div id="warantee_button">
                    <div><button class="reset-button"><a href="_reports.php"><i class="fa-solid fa-backward"></i></a></button></div>
                    
          </div>
        <h1>Yearly Reports </h1>
 
    <div class="nativeDatePicker">
  <input id="year" type="text" name="year" min="2020" max="3000" />
  <span class="validity"></span>
</div>
   <table class="table table-striped">
            <thead>

                <tr>
                    <th scope="col">Category</th>
                    <th scope="col">Product</th>
                    <th scope="col">Variation</th>
                  
                    <th scope="col">Quantity</th>
                    <th scope="col">Total Amount</th>
                </tr>
            </thead>
            <tbody>
               
                <tr>
                    <td colspan="5" style="text-align: right;"><strong>Total Sales:</strong></td>
                    <td></td>
                </tr>
            </tbody>
        </table>  
 

     </div>
     <section class="footer">
     <?php include('include/footer_two.php');         ?>
     
 </section>
</body>

<?php include("include/footer_link.php"); ?>
<script src="assets/script/script.js"></script>

<script>

$(document).ready(function() {
    $('#year').change(function() {
        var selectedYear = $(this).val();

        $.ajax({
            url: 'fetch_yearly_data.php',
            method: 'POST',
            data: { selectedYear: selectedYear },
            dataType: 'json',
            success: function(response) {
                console.log("Yearly Data Response:", response);

                $('.table tbody').empty();
                var totalSales = 0;

                $.each(response, function(index, item) {
                    var totalPriceCleaned = item.total_price ? parseFloat(item.total_price.replace(/[^\d.-]/g, '')) : 0;

                    var newRow = '<tr>' +
                        '<td>' + item.category + '</td>' +
                        '<td>' + item.product + '</td>' +
                        '<td>' + item.variation + '</td>' +
                       
                        '<td>' + item.total_items + '</td>' +
                        '<td>' + 'Rs '+ item.total_price + '</td>' +
                        '</tr>';
                    $('.table tbody').append(newRow);

                    totalSales += totalPriceCleaned;
                });

                // Remove existing total sales row
                $('.table tbody tr.total-sales').remove();

                // Prepend updated total sales row at the top of the table
                var totalSalesRow = '<tr class="total-sales"><td colspan="6" style="text-align: right;"><strong>Total Sales: Rs ' + totalSales.toFixed(2) + '</strong></td></tr>';
                $('.table tbody').prepend(totalSalesRow);
            },
            error: function(xhr, status, error) {
                console.error(xhr.responseText);
                alert('An error occurred while fetching data for the selected year.');
            }
        });
    });
});

</script>
</html>





